<?php


class AopsDripIntegration extends Aops {

	private $options = array();

	public function __construct() {
		$this->options = $this->getOptions();

		/* Check Drip Account ID when it`s entered */
		add_action( 'admin_init', array( $this, 'checkDripAccountId' ) );

		// added this check to make correct update from earlier plugin versions
		// which don't have this field and PHP notice about empty value may break user login
		if (isset($this->options['drip_script_disabled'])) {
			$addDrip = !$this->options['drip_script_disabled'];
		}
		else {
			$addDrip = true;
		}

		if ($addDrip) {
			/* Insert Drip tracking code */
			add_action( 'wp_footer', array( $this, 'placeDripTrackingCode' ), 10000 );
		}

	}

	public function checkDripAccountId() {
		if (isset($_POST['aops_cu_drip_account_id'])) {
			$newDripId = $_POST['aops_cu_drip_account_id'];
			if (is_numeric($newDripId)) {
				$newDripId = intval($newDripId);

				$dripApiUrl = 'http://tag.getdrip.com/' . $newDripId . '.js';
				$curl = AopsCurlHelper::get($dripApiUrl, array());

				// Check is response indicates successful connect to Drip
				if (strpos($curl, '"success":true') !== false) {
					$newDripStatus = self::STATUS_OK;
				}
				else {
					$newDripStatus = self::STATUS_FAIL;
				}

				// clear options cache
				wp_cache_delete ( 'alloptions', 'options' );
			}
			else {
				if ($newDripId == '') {
					$newDripStatus = self::STATUS_UNKNOWN;
				}
				else {
					$newDripStatus = self::STATUS_FAIL;
				}
			}

			// wordpress will use this later to save option into DB
			$_POST['aops_cu_drip_status'] = $newDripStatus;
		}
	}

	public function placeDripTrackingCode() {
		global $post;

		// check to avoid duplication of Drip codes for LP and CU plugins
		$duplication = false;
		if (is_object($post) && isset($post->post_type)) {
			if ($post->post_type == 'aops_landing_page') {
				$duplication = true;
			}
		}

		if (!$duplication) {
			if ($this->options['drip_account_id']) {
				$accountId = $this->options['drip_account_id'];
				?>
				<!-- Drip Code -->
				<script type="text/javascript">

					if (typeof _dcq === "undefined") { // check if script was not used earlier by some other plugin
						var _dcq = _dcq || [];
						var _dcs = _dcs || {};

						_dcs.account = '<?php echo $accountId ?>';

						(function() {
							var dc = document.createElement('script');
							dc.type = 'text/javascript'; dc.async = true;
							dc.src = '//tag.getdrip.com/<?php echo $accountId ?>.js';
							var s = document.getElementsByTagName('script')[0];
							s.parentNode.insertBefore(dc, s);
						})();
					}
					else {
						//console.log('Drip script already on the page');
					}
				</script>
				<?php
			}
		}
	}

}
?>
